
/*  PID Fiddler for Ball Ballancer with Sample Time
 *  By D Gundlach
 *  2/20/18
 *  
 *  fid.dle (fidl): to manipulate simething; tinker (often fol. by with).
 *  
 *  The PID Fiddler is a control to adjust PID values.  Its attached to
 *  your project with two wires.  It can be disconnected when not needed.
 *  
 *  The PID fiddler communicates with another Arduino by serial connection.
 *  It requires a function for reading serial and updating PID values to be 
 *  included in the recieving Arduino's sketch.
 *  
 *  When connected to a second Arduino, hold down the button.  While the button
 *  is depressed, make changes to Kp, Ki, and/or Kd.  The new values will be  
 *  displayed on the OLED.  When the button is released, the PID Fiddler will 
 *  transfer the new values.  
 *  
 *  Components:
 *  1 - Adafruit Monochrome 128x32 I2C OLED Graphic Display (931)
 *  1 - Momentary contact switch
 *  3 - 10K Ohm Pot
 *  
 *  Wiring (Arduino Uno)
 *  A0 = Sample Time Pot
 *  A1 - Kp Pot
 *  A2 - Ki Pot
 *  A3 - Kd Pot
 *  A4 - SDA OLED pin
 *  A5 - SCL OLED pin
 *  3  - RST OLED pin
 *  4  - Button
 *  
 */
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define OLED_RESET 3
Adafruit_SSD1306 display(OLED_RESET);

#define BUTTON  4     // Button Pin (Hold)
#define POTs    A0
#define POTp    A1
#define POTi    A2
#define POTd    A3
#define LED     13

double Setpoint, Input, Output;
double Kp=.3 , Ki=.15, Kd=0.4;
double Pp,Pi,Pd;
int Ps;
int hold = 1;
long timer=0;
int sampleTime = 400;

void setup() {
  Serial.begin(115200);
  pinMode(BUTTON, INPUT_PULLUP);
  pinMode(LED, OUTPUT);
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  display.setTextSize(1
  );
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.clearDisplay();
  display.print("Kp= ");
  display.println(Kp,2);
  display.print("Ki= ");
  display.println(Ki,2);
  display.print("Kd= ");
  display.println(Kd,2);
  display.print("ST= ");
  display.print(sampleTime);
  display.display();
  delay(200);
}

void loop() {
  hold = digitalRead(BUTTON);                     // Check button status
  if (!hold)Hold();                               // if button pressed jump to Hold() function
  if (timer<millis())digitalWrite(LED, LOW);
  
  int incoming = Serial.available();              // Check for incoming serial (not used)
  
  if (incoming > 0){
    int val = Serial.parseInt();
    display.setCursor(0,24);
    display.print(val);
    display.print("   ");
  }
  
}
void Hold(){                                      // Function ran when button depressed
  while(!hold){                                   // Stay in loop until button released
    Pp = analogRead(POTp);                        // Read pots
    Pi = analogRead(POTi);                        
    Pd = analogRead(POTd);
    Ps = analogRead(POTs);
    Pp = map(Pp, 0, 1023, 0, 100);                // Map values result between 0-100
    Pi = map(Pi, 0, 1023, 0, 100);
    Pd = map(Pd, 0, 1023, 0, 100);
    Ps = map(Ps, 0, 1023, 10, 600);
    Kp = Pp;
    Ki = Pi;
    Kd = Pd;
    sampleTime = Ps;
    
    display.setTextSize(1);                       // Update OLED display with new values
    display.setTextColor(WHITE);
    display.setCursor(0,0);
    display.clearDisplay();
    display.print("Kp= ");
    display.println(Kp/100,2);                    // values divided by 100
    display.print("Ki= ");
    display.println(Ki/100,2);
    display.print("Kd= ");
    display.println(Kd/100,2);
    display.print("ST= ");
    display.print(sampleTime);
    display.display();
    delay(200);
    hold = digitalRead(BUTTON);                   // read button status
  }                                               // when button released, send new values by serial
  delay(500);
  Serial.println(Kp);
  Serial.println(Ki+1000);
  Serial.println(Kd+2000);
  Serial.println(sampleTime+3000);
  digitalWrite(LED, HIGH);
  timer=millis()+500;
  return;
}

